// ==UserScript==
// @name         Twitch Clips - Show date & time
// @version      0.4.1
// @description  Displays the actual date & time of when a clip was created, instead of the useless "xxx days/months/weeks ago"
// @author       Decicus
// @updateURL    https://gist.github.com/Decicus/ec4745e680e06cfff5b1fa0a53fcff72/raw/twitch-clips-datetime.user.js
// @downloadURL  https://gist.github.com/Decicus/ec4745e680e06cfff5b1fa0a53fcff72/raw/twitch-clips-datetime.user.js
// @homepageURL  https://gist.github.com/Decicus/ec4745e680e06cfff5b1fa0a53fcff72
// @icon         https://i.alex.lol/2021-08-29_PmO4zo.png
// @match        https://clips.twitch.tv/*
// @license      MIT
// ==/UserScript==

async function fetchClip() {
    const slug = window.location.href.match(/https\:\/\/clips\.twitch\.tv\/([A-z0-9-_]+)/m)[1];
    
    if (!slug) {
        return;
    }

    const response = await fetch(`https://api.twitch.tv/kraken/clips/${slug}`, {
        headers: {
            Accept: 'application/vnd.twitchtv.v5+json',
            'Client-ID': 'zs377ogpzz01ogfx26pvbddx9jodg1',
        },
    });

    const data = await response.json();

    if (!data.created_at) {
        return;
    }

    const created = new Date(data.created_at);
    const dateAndTime = created.toLocaleString();

    const box = document.querySelector('.clips-sidebar-info');
    const layoutClass = box.classList[0];
    
    const textElement = document.querySelector('span[class*="CoreText"]');
    const textClass = textElement.classList[0];
    
    const element = document.createElement('div');
    element.className = layoutClass;
    element.setAttribute('style', 'text-align: center; margin-top: 1em;');
    element.innerHTML = `<span class="${textClass}"><strong>Clip created:</strong> ${dateAndTime}</span>`;

    box.insertAdjacentElement('afterbegin', element);
}

/**
 * Observe the DOM until we find the element we're interested in.
 * Once complete, disconnect the observer and call the `fetchClip()` function which actually inserts the
 * timestamp into the DOM.
 */
function observerHandler(mutations, observer)
{
    const textElement = document.querySelector('span[class*="CoreText"]');
    
    if (!textElement) {
        return;
    }
    
    fetchClip();
    observer.disconnect();
}

const observer = new MutationObserver(observerHandler);
observer.observe(document, {
    attributes: false,
    childList: true,
    characterData: false,
    subtree: true,
});