# Twitch clip datetime userscript

A userscript for displaying the actual date & time (relative to **local time**) of when a Twitch clip (and video) was created.

~~**FYI**: It only works on URLs that start with `https://clips.twitch.tv/`.~~  
~~This script does not work with URLs that are on the Twitch "channel pages" (`https://www.twitch.tv/CHANNEL_NAME_HERE/clip/...`).~~  
**This has been added as of v0.5.0.**

"Under the hood" the script uses [`Date.toLocaleString()`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleString) to format the date. The format of the date & time may differ from the screenshots below.

## Requirements

- Something like the [Violentmonkey](https://violentmonkey.github.io/get-it/) extension installed for your browser.

## Installation

1. Install a userscript extension (such as [Violentmonkey](https://violentmonkey.github.io/get-it/)).
2. Click on [this link](https://gist.github.com/Decicus/ec4745e680e06cfff5b1fa0a53fcff72/raw/twitch-clips-datetime.user.js) when Violentmonkey is installed, and it will prompt you to install the userscript.

## Support / Requests

If you have any requests or suggestions, feel free to [join my Discord server for all my projects](https://decapi.link/discord).

## Changelog

- v0.7.0 - 2024-05-09
  - Fixed the script so it now supports the new clip.twitch.tv layout.
    - Since they now use a similar layout as the main Twitch website, the position of the timestamp has been moved below the player. See [screenshots](#screenshots) at the bottom of this README.
- v0.6.0 - 2022-01-03
  - Added support for Twitch videos (VODs, highlights)
  - Switched API to use the new Twitch API (Helix) via an "API proxy" I host using Cloudflare Workers.
  - The observer should no longer disconnect after the first timestamp, allowing browsing to other videos/clips to work.
- v0.5.1 - 2021-12-30
  - Minor bug where it tried to fetch the date & time of a clip when watching highlights/VODs.
    - At some point I'll update the script to support VODs/highlights, but for now I'm sticking to clips.
- v0.5.0 - 2021-12-30
  - Script now supports clips on Twitch channel pages (e.g. `https://www.twitch.tv/$channelName/clip/$clipSlug`)
    - The `@match` rule will say `https://www.twitch.tv/*` to support navigating from the channel page to the clip page, otherwise script wouldn't load on regular Twitch browsing.
- v0.4.1 - 2021-08-29
  - Make script compatible with Tampermonkey again.
- v0.4.0 - 2021-08-29
  - Date/time placement was adjusted due to changes in the page on Twitch's end. See [screenshots](#screenshots).
  - ~~Previously I used Tampermonkey, but later switched to Violentmonkey. During my testing, I tested with Violentmonkey and it worked fine. However, if you're currently using Tampermonkey, v0.4.0 does not work. I'm unsure as to why, but I'll try to look into it.~~
  - Fixed in v0.4.1

## Screenshots

As of v0.4.0, the timestamp shows up a bit different compared to earlier versions.  
As of v0.7.0, the script was updated to support the new `clips.twitch.tv` layout. The timestamp was moved to be below the video player.

### On clips.twitch.tv

![Screenshot of userscript on clips.twitch.tv](https://i.alex.lol/2024-05-09_m99uou.png)

### Main Twitch website

When browsing Twitch channel clips on the main Twitch website.  
**Only v0.5.0 (December 30th, 2021) and newer**

![Screenshot of userscript on main Twitch website](https://i.alex.lol/2021-12-30_uK5V4S.png)

As of v0.6.0 (January 3rd, 2022), the script also works with Twitch videos (VODs, highlights).
