# Twitch clip datetime userscript

A userscript for displaying the actual date & time (relative to **local time**) of when a Twitch clip was created.

**FYI**: It only works on URLs that start with `https://clips.twitch.tv/`.  
This script does not work with URLs that are on the Twitch "channel pages" (`https://www.twitch.tv/CHANNEL_NAME_HERE/clip/...`).

"Under the hood" the script uses [`Date.toLocaleString()`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/toLocaleString) to format the date. The format of the date & time may differ from the screenshots below.

## Requirements:
- Something like the [Violentmonkey](https://violentmonkey.github.io/get-it/) extension installed for your browser.

## Installation:
1. Install a userscript extension (such as [Violentmonkey](https://violentmonkey.github.io/get-it/)).
2. Click on [this link](https://gist.github.com/Decicus/ec4745e680e06cfff5b1fa0a53fcff72/raw/twitch-clips-datetime.user.js) when Violentmonkey is installed, and it will prompt you to install the userscript.

## Changelog

- v0.4.0 - 2021-08-29
  - Date/time placement was adjusted due to changes in the page on Twitch's end. See [screenshots](#screenshots).
  - Previously I used Tampermonkey, but later switched to Violentmonkey. During my testing, I tested with Violentmonkey and it worked fine. However, if you're currently using Tampermonkey, v0.4.0 does not work. I'm unsure as to why, but I'll try to look into it.

## Screenshots:

As of v0.4.0, the timestamp shows up a bit different compared to earlier versions.

### Without chat (beginning of clip)

![Screenshot of userscript in action, before chat history loads](https://i.alex.lol/2021-08-29_r2lRVE.png)

### With chat

![Screenshot of userscript in action, with chat history loaded](https://i.alex.lol/2021-08-29_gO8qwL.png)
